
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <string.h>

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

class IntCell
{
public:

  //  IntCell(int initialValue = 0) : storedValue(initialValue) { }
  IntCell(int initialValue = 0) { storedValue = initialValue; }

  // "accessor" function

  int read() const  
  { return storedValue; }

  // "mutator" function

  int write(int x) 
  { storedValue = x; }

  void double_it();

  // overloaded insertion/extraction operators (friend means they're not member functions, but
  // they have the same privileges vis-a-vis accessing private variables)

  friend ostream & operator <<(ostream &, IntCell);
  friend istream & operator >>(istream &, IntCell &);

private:

  int storedValue;

};

//----------------------------------------------------------------------------

void IntCell::double_it()
{
  storedValue *= 2;
}

//----------------------------------------------------------------------------

ostream & operator <<(ostream &outputStream, IntCell a)
{
  cout << a.storedValue;
  
  return outputStream;
}

//----------------------------------------------------------------------------

istream & operator >>(istream &inputStream, IntCell & a)
{
  cin >> a.storedValue;
  
  return inputStream;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main()
{
  IntCell a;

  cout << "a = " << a << "\n";

  IntCell b(5);

  cout << "b = " << b << "\n";

  a = b;

  cout << "a = " << a << "\n";

  cout << "Please enter an integer\n";

  cin >> a;
  
  cout << "You entered " << a << endl;
  b = a;
  b.double_it();

  cout << "Two times that number is " << b << endl;

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



