
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <string.h>

#include "IntCell.hh"

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

class IntCellArray
{
public:

  IntCellArray(int = 1);

  void randomize();
  void print();

private:

  int size;
  IntCell *A;

};

//----------------------------------------------------------------------------

IntCellArray::IntCellArray(int initial_size)
{ 
  size = initial_size; 

  A = new IntCell[size];
}

//----------------------------------------------------------------------------

void IntCellArray::print()
{
  for (int i = 0; i < size; i++) 
    cout << A[i] << " ";
  cout << "\n";
}

//----------------------------------------------------------------------------

void IntCellArray::randomize()
{
  for (int i = 0; i < size; i++) 
    A[i].write(rand() % 10);
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

void init_rand()
{
  time_t now;

  now = time(NULL);
  srand(now);
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main()
{
  // verify that header file is working ok

  IntCell a;
  
  cout << "a = " << a << "\n";

  // (1) dynamic array of objects version

  IntCell *A;
  int n, i;

  init_rand();

  cout << "How big should the array be?\n";
  cin >> n;

  A = new IntCell[n];

  for (i = 0; i < n; i++) 
    A[i].write(rand() % 10);

  // print array

  for (i = 0; i < n; i++) 
    cout << A[i] << " ";
  cout << "\n";

  // (2) integrated array class version

  IntCellArray B(20);
  B.randomize();
  B.print();

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



