
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <string.h>

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

#define DEEP_COPY

const int MAX_STRLEN = 256;

class StringClass
{
public:

  // default constructor: empty string

  StringClass() 
  {  
    max_length = MAX_STRLEN; 
    a = new char[max_length]; 
    length = 0; 
  }

  StringClass(const char *s);

  ~StringClass();                                         // #1: destructor

#ifdef DEEP_COPY
  StringClass(StringClass &);                             // #2: copy constructor
  StringClass & operator=(const StringClass &);           // #3: assignment operator
#endif

  void print();

private:

  char *a;          // dynamic array for string chars
  int max_length;   // max size of array
  int length;       // actual number of chars used

};

//----------------------------------------------------------------------------

// constructor which takes string literal

StringClass::StringClass(const char *s)
{
 max_length = MAX_STRLEN; 
 a = new char[max_length]; 
 length = strlen(s); 

 for (int i = 0; i < length; i++)
   a[i] = s[i];
}

//----------------------------------------------------------------------------

// #1: destructor

StringClass::~StringClass()
{ 
  cout << "destructor!!\n"; 

  // "deep destructor": deallocate array that was dynamically-allocated in 
  // constructor to avoid a memory leak

  delete [] a; 
}

//----------------------------------------------------------------------------

// #2: copy constructor

#ifdef DEEP_COPY

StringClass::StringClass(StringClass & s)
{
 max_length = s.max_length; 
 length = s.length;

 a = new char[max_length];
 for (int i = 0; i < length; i++)
   a[i] = s.a[i];
}

//----------------------------------------------------------------------------

// #3: assignment operator

StringClass & StringClass::operator=(const StringClass & rhs)
{
  // only do something if we're NOT trying to assign a string to itself

  if (this != &rhs) {

    max_length = rhs.max_length;
    length = rhs.length;
    delete [] a;  

    a = new char[max_length];
    for (int i = 0; i < length; i++)
      a[i] = rhs.a[i];
  }

  return *this;
}

#endif

//----------------------------------------------------------------------------

void StringClass::print()
{
  for (int i = 0; i < length; i++)
    cout << a[i];
  cout << endl;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main()
{
  StringClass s("boolaboola");
  StringClass t("wahoo");
  StringClass u = s;   // u(s)

  s.print();
  t.print();
  u.print();

  // destructor on u (called automatically) unhappy because u.a was not new'd

  delete &s;  // not good because we didn't create s with new

  /*
  StringClass *s = new StringClass("boolaboola");
  StringClass *t = new StringClass("wahoo");
  StringClass *u = new StringClass(*s);            // copy constructor

  s->print();
  t->print();
  u->print();

  delete s;  // fine because s was created with new

  s = new StringClass("what?");
  s->print();

  u->print();   // try this with and without shallow copy

  delete s;
  delete t;
  delete u;   
  */

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



