//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

#include <cstdlib>
#include <iostream>

#include <vector>

using namespace std;

//----------------------------------------------------------------------------

// vectors

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

template<typename T>
void printVector(vector<T> & V, bool with_iterator = true)
{
  if (with_iterator) {

    typename vector<T>::iterator itr;
    
    for (itr = V.begin(); itr != V.end(); itr++)
      cout << *itr << endl;
  }
  else {

    for (int i = 0; i < V.size(); i++)
      cout << V[i] << endl;
  }
}

//----------------------------------------------------------------------------

template<typename T>
void printVectorBackward(vector<T> & V, bool with_iterator = true)
{
  if (with_iterator) {

    typename vector<T>::reverse_iterator ritr;  // note the different kind of iterator
    
    for (ritr = V.rbegin(); ritr != V.rend(); ritr++)
      cout << *ritr << endl;
  }
  else {

    for (int i = V.size() - 1; i >= 0; i--)
      cout << V[i] << endl;

  }
}

//----------------------------------------------------------------------------

// creating vector by adding at back (no push_front())--int version 

void int_add_back()
{
  vector<int> V;

  V.clear();

  V.push_back(33);
  V.push_back(42);
  V.push_back(27);
  V.push_back(78);

  cout << "forward\n";
  printVector(V);

  cout << "backward\n";
  printVectorBackward(V);  // note that we don't need to keep track of the tail

}

//----------------------------------------------------------------------------

// creating vector by adding at back (no push_front())--string version 

void string_add_back()
{
  vector<string> V;

  V.push_back("hp");
  V.push_back("dell");
  V.push_back("apple");
  V.push_back("sony");

  cout << ">> forward\n";
  printVector(V);

  cout << "<< backward\n";
  printVectorBackward(V);

}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main(int argc, char** argv)
{
  int_add_back();
  string_add_back();

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
