
#include <cstdlib>
#include <iostream>
#include <fstream>
#include <string.h>

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

template <typename T>
class AnythingCell
{
public:

  AnythingCell() { }
  AnythingCell(T initialValue) { storedValue = initialValue; }

  // "accessor" function

  T read() const  
  { return storedValue; }

  // "mutator" function

  T write(T x) 
  { storedValue = x; }

  void double_it();

  // overloaded insertion/extraction operators (friend means they're not member functions--even if
  // defined inline here!!!--but they have the same privileges vis-a-vis accessing private variables)

  friend ostream & operator <<(ostream & outputStream, AnythingCell <T> a)
  { 
    cout << a.storedValue;
    return outputStream;
  }

  friend istream & operator >>(istream & inputStream, AnythingCell <T> & a)
  {
    cin >> a.storedValue;
    return inputStream;
  }

private:

  T storedValue;

};

//----------------------------------------------------------------------------

template <typename T>
void AnythingCell<T>::double_it()
{
  storedValue = storedValue + storedValue;
}


//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main()
{
  AnythingCell <float> a(0.34);
  AnythingCell <float> b(10.9);

//   AnythingCell <int> a(5);
//   AnythingCell <int> b(10);

//   AnythingCell <string> a("boola");
//   AnythingCell <string> b("wahoo");

  cout << "a = " << a << "\n";
  cout << "b = " << b << "\n";

  a = b;
  cout << "a = " << a << "\n";

  cout << "Please enter...something\n";

  cin >> a;

   
  cout << "You entered " << a << endl;
  b = a;

  b.double_it();

  cout << "Two times that...thing... is " << b << endl;

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------



