//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

#include <cstdlib>
#include <iostream>

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

template <typename T = char >
class GeneralArray
{
public:
  GeneralArray(T [], int);
  
  void print();
  T smallest_element();

  int size() { return num_elements; }

private:
  T *array;
  int num_elements;
};

//----------------------------------------------------------------------------

template <typename T>
GeneralArray<T>::GeneralArray(T *arr, int n)
{
  num_elements = n;
  array = new T[num_elements];

  for (int i = 0; i < num_elements; i++)
    array[i] = arr[i];
}

//----------------------------------------------------------------------------

template <typename T>
void GeneralArray<T>::print()
{
  for (int i = 0; i < num_elements; i++)
    cout << array[i] << endl;
}

//----------------------------------------------------------------------------

template <typename T>
T GeneralArray<T>::smallest_element()
{
  int i;
  T smallest_so_far;

  smallest_so_far = array[0];
  for (i = 1; i < num_elements; i++)
    if (array[i] < smallest_so_far)
      smallest_so_far = array[i];

  return smallest_so_far;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

void example1()
{
  int A[5] = { 7, 9, 2, 10, 23 };

  GeneralArray <int> GA(A, 5);
  cout << "This array has " << GA.size() << " elements\n";
  GA.print();
  cout << "**" << GA.smallest_element() << "**" << "\n\n";


  string S[7] = { "umbrella",
		  "stingray",
		  "bicycle",
		  "aardvark",
		  "rainbow",
                  "puppy dog",
                  "lollipop" };

  GeneralArray <string> GS(S, 7);
  GS.print();
  cout << "**" << GS.smallest_element() << "**" << "\n\n";

  // default type ... must change class declaration above

  char C[3] = { 'd', 'o', 'g' };
  GeneralArray <> GC(C, 3);      
  GC.print();
  cout << "**" << GC.smallest_element() << "**" << "\n\n";

}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

template <typename T>
class AnythingCell
{
public:

  AnythingCell() { }
  AnythingCell(T initialValue) { storedValue = initialValue; }

  // "accessor" function

  T read() const  
  { return storedValue; }

  // "mutator" function

  T write(T x) 
  { storedValue = x; }

  void double_it();

  // overloaded insertion/extraction operators (friend means they're not member functions--even if
  // defined inline here!!!--but they have the same privileges vis-a-vis accessing private variables)

  friend ostream & operator <<(ostream & outputStream, AnythingCell <T> a)
  { 
    cout << a.storedValue;
    return outputStream;
  }

  friend istream & operator >>(istream & inputStream, AnythingCell <T> & a)
  {
    cin >> a.storedValue;
    return inputStream;
  }

  friend bool operator <(AnythingCell <T> & a, AnythingCell <T> & b)
  {
    return (a.storedValue < b.storedValue);
  }

private:

  T storedValue;

};

//----------------------------------------------------------------------------

template <typename T>
void AnythingCell<T>::double_it()
{
  storedValue = storedValue + storedValue;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

// could also do it this way

/*
  AnythingCell <float> AC[5];
  AC[0] = AnythingCell <float>(77.1);
  AC[1] = AnythingCell <float>(99.33);
  AC[2] = AnythingCell <float>(22.03);
  AC[3] = AnythingCell <float>(101.788);
  AC[4] = AnythingCell <float>(232.26);

  GeneralArray <AnythingCell <float> > GAC(AC, 5);
*/

void example2()
{
  AnythingCell <float> AC[5] = { 77.1, 99.33, 22.03, 101.788, 232.26 };

  GeneralArray < AnythingCell <float> > GAC(AC, 5);

  GAC.print();
  cout << "**" << GAC.smallest_element() << "**" << "\n";
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main(int argc, char** argv)
{
  //example1();
  example2();

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
