//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

#include <cstdlib>
#include <iostream>

using namespace std;

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

template<typename T>
class Node
{
public: 

  Node() { }
  Node(T theData, Node<T> *theNext) { data = theData; next = theNext; }

  T getData() { return data; }
  void setData(T theData) { data = theData; }

  Node<T> *getNext() { return next; }

  void setNext(Node<T> * theNext) { next = theNext; }


  void print() { cout << data << endl; }

private:

  T data;
  Node<T> *next;
};

//----------------------------------------------------------------------------

template<typename T>
class Stack
{
public:
  
  Stack() { top = NULL; size = 0; }    // make an empty stack

  void push(T);              // put item on the stack
  T pop();                   // take item off

  bool empty() { return top == NULL; }

  int size;

private:

  Node<T> *top;
};

//----------------------------------------------------------------------------

// item is new top of stack

template<typename T>
void Stack<T>::push(T theData)
{
  top = new Node<T>(theData, top);
  
  size++;
}

//----------------------------------------------------------------------------

// return item currently on top of stack

template<typename T>
T Stack<T>::pop()
{
  if (empty()) {
    cout << "Cannot pop empty stack!\n";
    exit(1);
  }

  T result = top->getData();

  Node<T> *discard; 
  discard = top;
  top = top->getNext();

  delete discard;

  size--;

  return result;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

void char_test()
{
  char next;

  Stack<char> s;

  cout << "Enter some text\n";
  cin.get(next);
  while (next != '\n') {
    s.push(next);
    cin.get(next);
  }

  cout << "Written backward that is:\n";

  while (!s.empty())
    cout << s.pop();
  cout << "\n";

}

//----------------------------------------------------------------------------

void string_test()
{
  string next;
  char c;

  Stack<string> s;

  cout << "Enter a sentence or two\n";

  while (cin >> next) {

    s.push(next);

    // was that the last word on the line?

    c = cin.get();

    if (c == '\n')
      break;
    else
      cin.putback(c);

  }

  cout << "Written backward that is:\n";
  
  while (!s.empty())
    cout << s.pop() << " ";
  cout << "\n";

}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------

int main(int argc, char** argv)
{
  //char_test();
  string_test();

  return 1;
}

//----------------------------------------------------------------------------
//----------------------------------------------------------------------------
